/* FILE: mfreerun.h                             (D. Tottingham  12/26/90)

This is an include file of defines, data structure definitions and
external declarations that are common in the mfreerun module.

*/

#ifndef _MFREERUN_
#define _MFREERUN_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define READY_STATE             0
#define START_FREERUN           1
#define CONTINUE_FREERUN        2
#define STOP_FREERUN            3


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC FLAG fr_continue_freerun ();
PUBLIC double fr_get_block_size ();
PUBLIC void fr_initialize ();
PUBLIC void fr_set_block_size (double);
PUBLIC void fr_start_freerun ();
PUBLIC void fr_stop_freerun ();
PUBLIC void fr_toggle_freerun ();

#endif
